<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Notification extends Model 
{

    protected $table = 'notifications';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function user_id()
    {
        return $this->belongsTo('App\Models\User');
    }

    public function notifeable()
    {
        return $this->morphTo();
    }

}